@extends('dashboard.layout')

@section('title', 'Home')

@section('content')
    <div class="row">
        @if (in_array(Auth::user()->role, array('admin', 'manager')))
            <div class="col-md-3">
                <div class="card mb-3 widget-content bg-premium-dark">
                    <div class="widget-content-wrapper text-white">
                        <div class="widget-content-left">
                            <div class="widget-heading">Total Active Admins</div>
                            <div class="widget-subheading">Count</div>
                        </div>
                        <div class="widget-content-right">
                            <div class="widget-numbers text-white"><span>
                                    @isset($totalActiveAdmins)
                                        {{ $totalActiveAdmins }}
                                    @endisset
                                </span></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mb-3 widget-content bg-grow-early">
                    <div class="widget-content-wrapper text-white">
                        <div class="widget-content-left">
                            <div class="widget-heading">Total Active Managers</div>
                            <div class="widget-subheading">Count</div>
                        </div>
                        <div class="widget-content-right">
                            <div class="widget-numbers text-white"><span>{{ $totalActiveManagers }}</span></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mb-3 widget-content bg-premium-dark">
                    <div class="widget-content-wrapper text-white">
                        <div class="widget-content-left">
                            <div class="widget-heading">Total Active Trainees</div>
                            <div class="widget-subheading">Count</div>
                        </div>
                        <div class="widget-content-right">
                            <div class="widget-numbers text-white"><span>{{ $totalActiveTrainees }}</span></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mb-3 widget-content bg-grow-early">
                    <div class="widget-content-wrapper text-white">
                        <div class="widget-content-left">
                            <div class="widget-heading">Total Active Employers</div>
                            <div class="widget-subheading">Count</div>
                        </div>
                        <div class="widget-content-right">
                            <div class="widget-numbers text-white"><span>{{ $totalActiveEmployers }}</span></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card mb-3 widget-content bg-premium-dark">
                    <div class="widget-content-wrapper text-white">
                        <div class="widget-content-left">
                            <div class="widget-heading">Total Inactive Users</div>
                            <div class="widget-subheading">Count</div>
                        </div>
                        <div class="widget-content-right">
                            <div class="widget-numbers text-white"><span>{{ $totalInactiveUsers }}</span></div>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <h2>Welcome. Please use the navigation on the left.</h2>
        @endif
    </div>
@endsection
