<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Language" content="en">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport"
          content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, shrink-to-fit=no"/>
    <meta name="description" content="Apprenticeship.">
    <meta name="msapplication-tap-highlight" content="no">

    <title><?php echo $__env->yieldContent('title'); ?></title>

    <link rel="icon" href="<?php echo e(asset('images/android-chrome-512x512.png')); ?>" sizes="512x512" type="image/png">
    <link rel="icon" href="<?php echo e(asset('images/android-chrome-192x192.png')); ?>" sizes="192x192" type="image/png">
    <link rel="icon" href="<?php echo e(asset('images/favicon-16x16.png')); ?>" sizes="16x16" type="image/png">
    <link rel="icon" href="<?php echo e(asset('images/favicon-32x32.png')); ?>" sizes="32x32" type="image/png">
    <link rel="icon" href="<?php echo e(asset('images/apple-touch-icon.png')); ?>" sizes="180x180" type="image/png">
    <link rel="icon" href="<?php echo e(asset('images/favicon.ico')); ?>">

    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/custom.css')); ?>" rel="stylesheet">

    <?php echo $__env->yieldContent('css_includes'); ?>
</head>
<body>
<div class="app-container app-theme-white body-tabs-shadow fixed-sidebar fixed-header">
    <div class="app-header header-shadow">
        <div class="app-header__logo">
            <div>
                <a href="<?php echo e(route('dashboard.home')); ?>">
                    <img src="<?php echo e(asset('images/logo.png')); ?>" style="height: 50px; width: 100px;">
                </a>
            </div>
            <div class="header__pane ml-auto">
                <div>
                    <button type="button" class="hamburger close-sidebar-btn hamburger--elastic"
                            data-class="closed-sidebar">
                        <span class="hamburger-box">
                            <span class="hamburger-inner"></span>
                        </span>
                    </button>
                </div>
            </div>
        </div>
        <div class="app-header__mobile-menu">
            <div>
                <button type="button" class="hamburger hamburger--elastic mobile-toggle-nav">
                    <span class="hamburger-box">
                        <span class="hamburger-inner"></span>
                    </span>
                </button>
            </div>
        </div>
        <div class="app-header__menu">
            <span>
                <button type="button" class="btn-icon btn-icon-only btn btn-primary btn-sm mobile-toggle-header-nav">
                    <span class="btn-icon-wrapper">
                        <i class="fa fa-ellipsis-v fa-w-6"></i>
                    </span>
                </button>
            </span>
        </div>
        <div class="app-header__content">
            <div class="app-header-right">
                <div class="header-btn-lg pr-0">
                    <div class="widget-content p-0">
                        <div class="widget-content-wrapper">
                            <div class="widget-content-left">
                                <div class="btn-group">
                                    <a data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"
                                       class="p-0 btn">
                                        <img width="42" class="rounded-circle" src="<?php echo e(asset('images/user.png')); ?>"
                                             alt="">
                                        <i class="fa fa-angle-down ml-2 opacity-8"></i>
                                    </a>
                                    <div tabindex="-1" role="menu" aria-hidden="true"
                                         class="dropdown-menu dropdown-menu-right">
                                        <input id="user_name" name="user_name" type="hidden" value="<?php echo e(Auth::user()->first_name); ?> <?php echo e(Auth::user()->last_name); ?>" />
                                        <input id="user_email" name="user_email" type="hidden" value="<?php echo e(Auth::user()->email); ?>" />
                                        <a class="dropdown-item" href="<?php echo e(route('users.edit', Auth::user()->id)); ?>">Profile</a>
                                        <div tabindex="-1" class="dropdown-divider"></div>
                                        <button type="button" tabindex="0" class="dropdown-item"
                                                onclick="event.preventDefault(); document.getElementById('logOut').submit();">
                                            Logout
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="widget-content-left  ml-3 header-user-info">
                                <div class="widget-heading">
                                    <?php echo e(Auth::user()->first_name); ?>

                                </div>
                                <div class="widget-subheading">
                                    <?php echo e(Auth::user()->role); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="app-main">
        <div class="app-sidebar sidebar-shadow">
            <div class="app-header__logo">
                <div class="logo-src"></div>
                <div class="header__pane ml-auto">
                    <div>
                        <button type="button" class="hamburger close-sidebar-btn hamburger--elastic"
                                data-class="closed-sidebar">
                            <span class="hamburger-box">
                                <span class="hamburger-inner"></span>
                            </span>
                        </button>
                    </div>
                </div>
            </div>
            <div class="app-header__mobile-menu">
                <div>
                    <button type="button" class="hamburger hamburger--elastic mobile-toggle-nav">
                        <span class="hamburger-box">
                            <span class="hamburger-inner"></span>
                        </span>
                    </button>
                </div>
            </div>
            <div class="app-header__menu">
                <span>
                    <button type="button"
                            class="btn-icon btn-icon-only btn btn-primary btn-sm mobile-toggle-header-nav">
                        <span class="btn-icon-wrapper">
                            <i class="fa fa-ellipsis-v fa-w-6"></i>
                        </span>
                    </button>
                </span>
            </div>
            <div class="scrollbar-sidebar">
                <div class="app-sidebar__inner">
                    <ul class="vertical-nav-menu">
                        <li class="app-sidebar__heading">Dashboard</li>
                        <li>
                            <a href="<?php echo e(route('home')); ?>">
                                <i class="metismenu-icon fa fa-home"></i>
                                Site
                            </a>
                        </li>
                        <li>
                            <a href="javascript:;">
                                <i class="metismenu-icon pe-7s-bookmarks"></i>
                                Products
                                <i class="metismenu-state-icon pe-7s-angle-down caret-left"></i>
                            </a>
                            <ul>
                                <li>
                                    <a href="<?php echo e(route('products.create')); ?>">
                                        <i class="metismenu-icon">
                                        </i>Create
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('products.index')); ?>">
                                        <i class="metismenu-icon">
                                        </i>List
                                    </a>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="javascript:;">
                                <i class="metismenu-icon pe-7s-bookmarks"></i>
                                Users
                                <i class="metismenu-state-icon pe-7s-angle-down caret-left"></i>
                            </a>
                            <ul>
                                <li>
                                    <a href="<?php echo e(route('users.create')); ?>">
                                        <i class="metismenu-icon">
                                        </i>Create
                                    </a>
                                </li>
                                <li>
                                    <a href="<?php echo e(route('users.index')); ?>">
                                        <i class="metismenu-icon">
                                        </i>List
                                    </a>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="app-main__outer">
            <div class="app-main__inner">
                <?php if(session()->has('message_success')): ?>
                    <div class="mb-3 card text-white card-body bg-success">
                        <?php echo e(session('message_success')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session()->has('message_fail')): ?>
                    <div class="mb-3 card text-white card-body bg-danger">
                        <?php echo e(session('message_fail')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session()->has('message_info')): ?>
                    <div class="mb-3 card text-white card-body bg-info">
                        <?php echo e(session('message_info')); ?>

                    </div>
                <?php endif; ?>
                <?php if(session()->has('message_warning')): ?>
                    <div class="mb-3 card text-white card-body bg-warning">
                        <?php echo e(session('message_warning')); ?>

                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="mb-3 card text-white card-body bg-info">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </div>
            <div class="app-wrapper-footer">
                <div class="app-footer">
                    <div class="app-footer__inner">
                        <div class="app-footer-left"></div>
                        <div class="app-footer-right">
                            <ul class="nav">
                                <li class="nav-item">
                                    <a href="" class="nav-link">Fashion</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<form id="logOut" action="<?php echo e(route('logout')); ?>" method="post" style="display:none;">
    <?php echo csrf_field(); ?>
    <button type="submit">logout</button>
</form>
<script type="text/javascript" src="<?php echo e(asset('js/app.js')); ?>"></script>


<!-- Custom JS -->


<!-- JS from views -->
<?php echo $__env->yieldContent('js'); ?>

</body>
</html>
<?php /**PATH /Users/air/Documents/laravel/fashion/resources/views/dashboard/layout.blade.php ENDPATH**/ ?>