<?php $__env->startSection('title', 'Users'); ?>

<?php $__env->startSection('content'); ?>
    <div class="main-card mb-3 card">
        <div class="card-body">
            <div class="mb-3 card card-body text-center">
                <h3>Users</h3>
            </div>
            <?php if(!$users->isEmpty()): ?>
                <p>
                    <button id="download-button" class="btn btn-info">Download CSV</button>
                </p>
                <table style="width: 100%;" id="example"
                       class="table table-hover table-striped table-bordered">
                    <thead>
                    <tr>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th>Tel</th>
                        <th>Role</th>
                        <th>Active</th>
                        <th>Registered on</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($user->first_name); ?></td>
                            <td><?php echo e($user->last_name); ?></td>
                            <td><?php echo e($user->email); ?></td>
                            <td><?php echo e($user->tel); ?></td>
                            <td><?php echo e(ucfirst($user->role)); ?></td>
                            <td><?php echo e($user->status); ?></td>
                            <td><?php echo e(date('m/d/Y', strtotime($user->created_at))); ?></td>
                            <td>
                                <form action="<?php echo e(route('users.destroy', $user->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <a href="<?php echo e(route('users.show', $user->id)); ?>" class="btn btn-info"><i
                                                class="fa fa-eye"></i></a>
                                    <?php if(in_array(Auth::user()->role, array('admin'))): ?>
                                    <a href="<?php echo e(route('users.edit', $user->id)); ?>" class="btn btn-warning"><i
                                                class="fa fa-edit"></i></a>
                                    <button class="btn btn-danger" type="submit"><i class="fa fa-trash"></i>
                                    </button>
                                    <?php endif; ?>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th>First Name</th>
                        <th>Last Name</th>
                        <th>Email</th>
                        <th>Tel</th>
                        <th>Role</th>
                        <th>Status</th>
                        <th>Registered on</th>
                        <th>Actions</th>
                    </tr>
                    </tfoot>
                </table>
            <?php else: ?>
                <a href="<?php echo e(route('users.create')); ?>" class="mb-2 mr-2 btn btn-success">Create</a>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/air/Documents/laravel/fashion/resources/views/dashboard/users/index.blade.php ENDPATH**/ ?>