<?php $__env->startSection('title', 'Products'); ?>

<?php $__env->startSection('content'); ?>
    <div class="main-card mb-3 card">
        <div class="card-body">
            <div class="mb-3 card card-body text-center">
                <h3>Products</h3>
            </div>
            <?php if(!$products->isEmpty()): ?>
                
                <table style="width: 100%;" id="example"
                       class="table table-hover table-striped table-bordered">
                    <thead>
                    <tr>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Gender</th>
                        <th>Stock</th>
                        <th>Saved on</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><img src="<?php echo e(asset("items/".$product->main_image)); ?>" alt="product_image" class="img-table"></td>
                            <td><?php echo e($product->name); ?></td>
                            <td><?php echo e($product->gender); ?></td>
                            <td><?php echo e($product->stock); ?></td>
                            <td><?php echo e(date('m/d/Y', strtotime($product->created_at))); ?></td>
                            <td>
                                <form action="<?php echo e(route('products.destroy', $product->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <a href="<?php echo e(route('products.show', $product->id)); ?>" class="btn btn-info"><i
                                                class="fa fa-eye"></i></a>
                                    <?php if(in_array(Auth::user()->role, array('admin'))): ?>
                                    <a href="<?php echo e(route('products.edit', $product->id)); ?>" class="btn btn-warning"><i
                                                class="fa fa-edit"></i></a>
                                    <button class="btn btn-danger" type="submit"><i class="fa fa-trash"></i>
                                    </button>
                                    <?php endif; ?>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Gender</th>
                        <th>Stock</th>
                        <th>Saved on</th>
                        <th>Actions</th>
                    </tr>
                    </tfoot>
                </table>
            <?php else: ?>
                <a href="<?php echo e(route('products.create')); ?>" class="mb-2 mr-2 btn btn-success">Create</a>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('dashboard.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/air/Documents/laravel/fashion/resources/views/dashboard/products/index.blade.php ENDPATH**/ ?>